<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//    Copyright (C) 2010 Matteo Lucarelli
//    Copyright (C) 2011-2013 Uwe Steinmann
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//    Translators: Admin (975), netixw (14)

$text = array(
'accept' => 'Accept',
'access_denied' => 'Access denied.',
'access_inheritance' => 'Access Inheritance',
'access_mode' => 'Access mode',
'access_mode_all' => 'All permissions',
'access_mode_none' => 'No access',
'access_mode_read' => 'Read permissions',
'access_mode_readwrite' => 'Read-Write permissions',
'access_permission_changed_email' => 'Permission changed',
'access_permission_changed_email_body' => 'Permission changed
Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'access_permission_changed_email_subject' => '[sitename]: [name] - Permission changed',
'according_settings' => 'according settings',
'action' => 'Action',
'actions' => 'Actions',
'action_approve' => 'Approve',
'action_complete' => 'Complete',
'action_is_complete' => 'Is complete',
'action_is_not_complete' => 'Is not complete',
'action_reject' => 'Reject',
'action_review' => 'Review',
'action_revise' => 'Revise',
'add' => 'Add',
'add_document' => 'Add document',
'add_document_link' => 'Add link',
'add_doc_reviewer_approver_warning' => 'N.B. Documents are automatically marked as released if no reviewer or approver is assigned.',
'add_doc_workflow_warning' => 'N.B. Documents are automatically marked as released if no workflow is assigned.',
'add_event' => 'Add event',
'add_group' => 'Add new group',
'add_member' => 'Add a member',
'add_multiple_documents' => 'Add multiple documents',
'add_multiple_files' => 'Add multiple files (will use filename as document name)',
'add_subfolder' => 'Add subfolder',
'add_to_clipboard' => 'Add to clipboard',
'add_user' => 'Add new user',
'add_user_to_group' => 'Add user to group',
'add_workflow' => 'Add new workflow',
'add_workflow_action' => 'Add new workflow action',
'add_workflow_state' => 'Add new workflow state',
'admin' => 'Administrator',
'admin_tools' => 'Admin-Tools',
'all' => 'All',
'all_categories' => 'All categories',
'all_documents' => 'All Documents',
'all_pages' => 'All',
'all_users' => 'All users',
'already_subscribed' => 'Already subscribed',
'and' => 'and',
'apply' => 'Apply',
'approval_deletion_email' => 'Approval request deleted',
'approval_group' => 'Approval Group',
'approval_request_email' => 'Approval request',
'approval_request_email_body' => 'Approval request
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'approval_request_email_subject' => '[sitename]: [name] - Approval request',
'approval_status' => 'Approval Status',
'approval_submit_email' => 'Submitted approval',
'approval_summary' => 'Approval Summary',
'approval_update_failed' => 'Error updating approval status. Update failed.',
'approvers' => 'Approvers',
'april' => 'April',
'archive_creation' => 'Archive creation',
'archive_creation_warning' => 'With this operation you can create archive containing the files of entire DMS folders. After the creation the archive will be saved in the data folder of your server.<br>WARNING: an archive created as human readable will be unusable as server backup.',
'ar_EG' => 'Arabic',
'assign_approvers' => 'Assign Approvers',
'assign_reviewers' => 'Assign Reviewers',
'assign_user_property_to' => 'Assign user\'s properties to',
'assumed_released' => 'Assumed released',
'attrdef_exists' => 'Attribute definition already exists',
'attrdef_in_use' => 'Attribute definition still in use',
'attrdef_management' => 'Attribute definition management',
'attrdef_maxvalues' => 'Max. number of values',
'attrdef_minvalues' => 'Min. number of values',
'attrdef_multiple' => 'Allow multiple values',
'attrdef_name' => 'Name',
'attrdef_objtype' => 'Object type',
'attrdef_regex' => 'Regular expression',
'attrdef_type' => 'Type',
'attrdef_valueset' => 'Set of values',
'attributes' => 'Attributes',
'attribute_changed_email_body' => 'Attribute changed
Document: [name]
Version: [version]
Attribute: [attribute]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'attr_no_regex_match' => 'The attribute value does not match the regular expression',
'at_least_n_users_of_group' => 'At least [number_of_users] users of [group]',
'august' => 'August',
'automatic_status_update' => 'Automatic status change',
'back' => 'Go back',
'backup_list' => 'Existings backup list',
'backup_log_management' => 'Backup/Logging',
'backup_remove' => 'Remove backup file',
'backup_tools' => 'Backup tools',
'between' => 'between',
'calendar' => 'Calendar',
'calendar_week' => 'Calendar week',
'cancel' => 'Cancel',
'cannot_assign_invalid_state' => 'Cannot modify an obsolete or rejected document',
'cannot_change_final_states' => 'Warning: You cannot alter status for document rejected, expired or with pending review or approval',
'cannot_delete_user' => 'Cannot delete user',
'cannot_delete_yourself' => 'Cannot delete yourself',
'cannot_move_root' => 'Error: Cannot move root folder.',
'cannot_retrieve_approval_snapshot' => 'Unable to retrieve approval status snapshot for this document version.',
'cannot_retrieve_review_snapshot' => 'Unable to retrieve review status snapshot for this document version.',
'cannot_rm_root' => 'Error: Cannot delete root folder.',
'categories' => 'Categories',
'category' => 'Category',
'category_exists' => 'Category already exists.',
'category_filter' => 'Only categories',
'category_in_use' => 'This category is currently used by documents.',
'category_noname' => 'No category name given.',
'ca_ES' => 'Catalan',
'change_assignments' => 'Change Assignments',
'change_password' => 'Change password',
'change_password_message' => 'Your password has been changed.',
'change_status' => 'Change Status',
'choose_attrdef' => 'Please choose attribute definition',
'choose_category' => 'Please choose',
'choose_group' => 'Choose group',
'choose_target_category' => 'Choose category',
'choose_target_document' => 'Choose document',
'choose_target_file' => 'Choose file',
'choose_target_folder' => 'Choose folder',
'choose_user' => 'Choose user',
'choose_workflow' => 'Choose workflow',
'choose_workflow_action' => 'Choose workflow action',
'choose_workflow_state' => 'Choose workflow state',
'clear_clipboard' => 'Clear clipboard',
'clipboard' => 'Clipboard',
'close' => 'Close',
'comment' => 'Comment',
'comment_for_current_version' => 'Version comment',
'confirm_create_fulltext_index' => 'Yes, I would like to recreate the fulltext index!',
'confirm_pwd' => 'Confirm Password',
'confirm_rm_backup' => 'Do you really want to remove the file "[arkname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_document' => 'Do you really want to remove the document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_dump' => 'Do you really want to remove the file "[dumpname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_event' => 'Do you really want to remove event "[name]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_file' => 'Do you really want to remove file "[name]" of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder' => 'Do you really want to remove the folder "[foldername]" and its content?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder_files' => 'Do you really want to remove all the files of the folder "[foldername]" and of its subfolders?<br>Be careful: This action cannot be undone.',
'confirm_rm_group' => 'Do you really want to remove the group "[groupname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_log' => 'Do you really want to remove log file "[logname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_user' => 'Do you really want to remove the user "[username]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_version' => 'Do you really want to remove version [version] of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'content' => 'Content',
'continue' => 'Continue',
'create_fulltext_index' => 'Create fulltext index',
'create_fulltext_index_warning' => 'You are to recreate the fulltext index. This can take a considerable amount of time and reduce your overall system performance. If you really want to recreate the index, please confirm your operation.',
'creation_date' => 'Created',
'cs_CZ' => 'Czech',
'current_password' => 'Current Password',
'current_state' => 'Current state',
'current_version' => 'Current version',
'daily' => 'Daily',
'databasesearch' => 'Database search',
'date' => 'Date',
'days' => 'days',
'december' => 'December',
'default_access' => 'Default Access Mode',
'default_keywords' => 'Available keywords',
'definitions' => 'Definitions',
'delete' => 'Delete',
'details' => 'Details',
'details_version' => 'Details for version: [version]',
'de_DE' => 'German',
'disclaimer' => 'This is a classified area. Access is permitted only to authorized personnel. Any violation will be prosecuted according to the national and international laws.',
'document' => 'Document',
'documents' => 'Documents',
'documents_in_process' => 'Documents In Process',
'documents_locked_by_you' => 'Documents locked by you',
'documents_only' => 'Documents only',
'documents_to_approve' => 'Documents awaiting your approval',
'documents_to_review' => 'Documents awaiting your review',
'documents_user_requiring_attention' => 'Documents owned by you that require attention',
'document_already_locked' => 'This document is aleady locked',
'document_comment_changed_email' => 'Comment changed',
'document_comment_changed_email_body' => 'Comment changed
Document: [name]
Old comment: [old_comment]
Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'document_deleted' => 'Document deleted',
'document_deleted_email' => 'Document deleted',
'document_deleted_email_body' => 'Document deleted
Document: [name]
Parent folder: [folder_path]
User: [username]',
'document_deleted_email_subject' => '[sitename]: [name] - Document deleted',
'document_duplicate_name' => 'Duplicate document name',
'document_has_no_workflow' => 'Document has no workflow',
'document_infos' => 'Document Information',
'document_is_not_locked' => 'This document is not locked',
'document_link_by' => 'Linked by',
'document_link_public' => 'Public',
'document_moved_email' => 'Document moved',
'document_moved_email_body' => 'Document moved
Document: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'document_moved_email_subject' => '[sitename]: [name] - Document moved',
'document_renamed_email' => 'Document renamed',
'document_renamed_email_body' => 'Document name changed
Document: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'document_renamed_email_subject' => '[sitename]: [name] - Document renamed',
'document_status_changed_email' => 'Document status changed',
'document_status_changed_email_body' => 'Document status changed
Document: [name]
Status: [status]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_status_changed_email_subject' => '[sitename]: [name] - Document status changed',
'document_title' => 'Document \'[documentname]\'',
'document_updated_email' => 'Document updated',
'document_updated_email_body' => 'Document updated
Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_updated_email_subject' => '[sitename]: [name] - Document updated',
'does_not_expire' => 'Does not expire',
'does_not_inherit_access_msg' => 'Inherit access',
'download' => 'Download',
'do_object_repair' => 'Repair all folders and documents.',
'do_object_setchecksum' => 'Set checksum',
'do_object_setfilesize' => 'Set file size',
'do_object_unlink' => 'Delete document version',
'draft_pending_approval' => 'Draft - pending approval',
'draft_pending_review' => 'Draft - pending review',
'drag_icon_here' => 'Drag icon of folder or document here!',
'dropfolder_file' => 'File from drop folder',
'dump_creation' => 'DB dump creation',
'dump_creation_warning' => 'With this operation you can create a dump file of your database content. After the creation the dump file will be saved in the data folder of your server.',
'dump_list' => 'Existings dump files',
'dump_remove' => 'Remove dump file',
'edit' => 'Edit',
'edit_attributes' => 'Edit attributes',
'edit_comment' => 'Edit comment',
'edit_default_keywords' => 'Edit keywords',
'edit_document_access' => 'Edit Access',
'edit_document_notify' => 'Document Notification List',
'edit_document_props' => 'Edit document',
'edit_event' => 'Edit event',
'edit_existing_access' => 'Edit Access List',
'edit_existing_notify' => 'Edit notification list',
'edit_folder_access' => 'Edit access',
'edit_folder_notify' => 'Folder Notification List',
'edit_folder_props' => 'Edit folder',
'edit_group' => 'Edit group',
'edit_user' => 'Edit user',
'edit_user_details' => 'Edit User Details',
'email' => 'Email',
'email_error_title' => 'No email entered',
'email_footer' => 'You can always change your e-mail settings using \'My Account\' functions',
'email_header' => 'This is an automatic message from the DMS server.',
'email_not_given' => 'Please enter a valid email address.',
'empty_folder_list' => 'No documents or folders',
'empty_notify_list' => 'No entries',
'en_GB' => 'English (GB)',
'equal_transition_states' => 'Start and end state are equal',
'error' => 'Error',
'error_no_document_selected' => 'No document selected',
'error_no_folder_selected' => 'No folder selected',
'error_occured' => 'An error has occured',
'es_ES' => 'Spanish',
'event_details' => 'Event details',
'expired' => 'Expired',
'expires' => 'Expires',
'expiry_changed_email' => 'Expiry date changed',
'expiry_changed_email_body' => 'Expiry date changed
Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'expiry_changed_email_subject' => '[sitename]: [name] - Expiry date changed',
'extension_manager' => 'Manage extensions',
'february' => 'February',
'file' => 'File',
'files' => 'Files',
'files_deletion' => 'Files deletion',
'files_deletion_warning' => 'With this option you can delete all files of entire DMS folders. The versioning information will remain visible.',
'file_size' => 'Filesize',
'folder' => 'Folder',
'folders' => 'Folders',
'folders_and_documents_statistic' => 'Contents overview',
'folder_comment_changed_email' => 'Comment changed',
'folder_comment_changed_email_body' => 'Comment changed
Folder: [name]
Version: [version]
Old comment: [old_comment]
Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_comment_changed_email_subject' => '[sitename]: [folder] - Comment changed',
'folder_contents' => 'Folder Contents',
'folder_deleted_email' => 'Folder deleted',
'folder_deleted_email_body' => 'Folder deleted
Folder: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_deleted_email_subject' => '[sitename]: [name] - Folder deleted',
'folder_infos' => 'Folder Information',
'folder_moved_email' => 'Folder moved',
'folder_moved_email_body' => 'Folder move
Folder: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'folder_moved_email_subject' => '[sitename]: [name] - Folder moved',
'folder_renamed_email' => 'Folder renamed',
'folder_renamed_email_body' => 'Folder renamed
Folder: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'folder_renamed_email_subject' => '[sitename]: [name] - Folder renamed',
'folder_title' => 'Folder \'[foldername]\'',
'friday' => 'Friday',
'friday_abbr' => 'Fr',
'from' => 'From',
'fr_FR' => 'French',
'fullsearch' => 'Full text search',
'fullsearch_hint' => 'Use fulltext index',
'fulltext_info' => 'Fulltext index info',
'global_attributedefinitions' => 'Attributes',
'global_default_keywords' => 'Global keywords',
'global_document_categories' => 'Categories',
'global_workflows' => 'Workflows',
'global_workflow_actions' => 'Workflow Actions',
'global_workflow_states' => 'Workflow States',
'group' => 'Group',
'groups' => 'Groups',
'group_approval_summary' => 'Group approval summary',
'group_exists' => 'Group already exists.',
'group_management' => 'Groups management',
'group_members' => 'Group members',
'group_review_summary' => 'Group review summary',
'guest_login' => 'Login as guest',
'guest_login_disabled' => 'Guest login is disabled.',
'help' => 'Help',
'hourly' => 'Hourly',
'hours' => 'hours',
'human_readable' => 'Human readable archive',
'hu_HU' => 'Hungarian',
'id' => 'ID',
'identical_version' => 'New version is identical to current version.',
'include_documents' => 'Include documents',
'include_subdirectories' => 'Include subdirectories',
'index_converters' => 'Index document conversion',
'individuals' => 'Individuals',
'inherited' => 'inherited',
'inherits_access_copy_msg' => 'Copy inherited access list',
'inherits_access_empty_msg' => 'Start with empty access list',
'inherits_access_msg' => 'Access is being inherited.',
'internal_error' => 'Internal error',
'internal_error_exit' => 'Internal error. Unable to complete request. Exiting.',
'invalid_access_mode' => 'Invalid Access Mode',
'invalid_action' => 'Invalid Action',
'invalid_approval_status' => 'Invalid Approval Status',
'invalid_create_date_end' => 'Invalid end date for creation date range.',
'invalid_create_date_start' => 'Invalid start date for creation date range.',
'invalid_doc_id' => 'Invalid Document ID',
'invalid_file_id' => 'Invalid file ID',
'invalid_folder_id' => 'Invalid Folder ID',
'invalid_group_id' => 'Invalid Group ID',
'invalid_link_id' => 'Invalid link identifier',
'invalid_request_token' => 'Invalid Request Token',
'invalid_review_status' => 'Invalid Review Status',
'invalid_sequence' => 'Invalid sequence value',
'invalid_status' => 'Invalid Document Status',
'invalid_target_doc_id' => 'Invalid Target Document ID',
'invalid_target_folder' => 'Invalid Target Folder ID',
'invalid_user_id' => 'Invalid User ID',
'invalid_version' => 'Invalid Document Version',
'in_workflow' => 'In workflow',
'is_disabled' => 'Disable account',
'is_hidden' => 'Hide from users list',
'it_IT' => 'Italian',
'january' => 'January',
'js_no_approval_group' => 'Please select a approval group',
'js_no_approval_status' => 'Please select the approval status',
'js_no_comment' => 'There is no comment',
'js_no_email' => 'Type in your Email-address',
'js_no_file' => 'Please select a file',
'js_no_keywords' => 'Specify some keywords',
'js_no_login' => 'Please type in a username',
'js_no_name' => 'Please type in a name',
'js_no_override_status' => 'Please select the new [override] status',
'js_no_pwd' => 'You need to type in your password',
'js_no_query' => 'Type in a query',
'js_no_review_group' => 'Please select a review group',
'js_no_review_status' => 'Please select the review status',
'js_pwd_not_conf' => 'Password and passwords-confirmation are not equal',
'js_select_user' => 'Please select an user',
'js_select_user_or_group' => 'Select at least a user or a group',
'july' => 'July',
'june' => 'June',
'keep_doc_status' => 'Keep document status',
'keywords' => 'Keywords',
'keyword_exists' => 'Keyword already exists',
'language' => 'Language',
'last_update' => 'Last Update',
'legend' => 'Legend',
'linked_documents' => 'Related Documents',
'linked_files' => 'Attachments',
'link_alt_updatedocument' => 'If you would like to upload files bigger than the current maximum upload size, please use the alternative <a href="%s">upload page</a>.',
'local_file' => 'Local file',
'locked_by' => 'Locked by',
'lock_document' => 'Lock',
'lock_message' => 'This document is locked by <a href="mailto:[email]">[username]</a>. Only authorized users can unlock this document.',
'lock_status' => 'Status',
'login' => 'Login',
'login_disabled_text' => 'Your account is disabled, probably because of too many failed logins.',
'login_disabled_title' => 'Account is disabled',
'login_error_text' => 'Error signing in. User ID or password incorrect.',
'login_error_title' => 'Sign in error',
'login_not_given' => 'No username has been supplied',
'login_ok' => 'Sign in successful',
'logout' => 'Logout',
'log_management' => 'Log files management',
'manager' => 'Manager',
'march' => 'March',
'max_upload_size' => 'Maximum upload size',
'may' => 'May',
'mimetype' => 'Mime type',
'minutes' => 'minutes',
'misc' => 'Misc',
'missing_checksum' => 'Missing checksum',
'missing_filesize' => 'Missing filesize',
'missing_transition_user_group' => 'Missing user/group for transition',
'monday' => 'Monday',
'monday_abbr' => 'Mo',
'monthly' => 'Monthly',
'month_view' => 'Month view',
'move' => 'Move',
'move_clipboard' => 'Move clipboard',
'move_document' => 'Move document',
'move_folder' => 'Move Folder',
'my_account' => 'My Account',
'my_documents' => 'My Documents',
'name' => 'Name',
'needs_workflow_action' => 'This document requires your attention. Please check the workflow tab.',
'new' => 'New',
'new_attrdef' => 'Add attribute defintion',
'new_default_keywords' => 'Add keywords',
'new_default_keyword_category' => 'Add category',
'new_document_category' => 'Add category',
'new_document_email' => 'New document',
'new_document_email_body' => 'New document
Name: [name]
Parent folder: [folder_path]
Comment: [comment]
Version comment: [version_comment]
User: [username]
URL: [url]',
'new_document_email_subject' => '[sitename]: [folder_name] - New document',
'new_file_email' => 'New attachment',
'new_file_email_body' => 'New attachmentrnName: [name]
Document: [document]
Comment: [comment]
User: [username]
URL: [url]',
'new_file_email_subject' => '[sitename]: [document] - New attachment',
'new_folder' => 'New folder',
'new_password' => 'New password',
'new_subfolder_email' => 'New folder',
'new_subfolder_email_body' => 'New folder
Name: [name]
Parent folder: [folder_path]
Comment: [comment]
User: [username]
URL: [url]',
'new_subfolder_email_subject' => '[sitename]: [name] - New folder',
'new_user_image' => 'New image',
'next_state' => 'New state',
'nl_NL' => 'Dutch',
'no' => 'No',
'notify_added_email' => 'You\'ve been added to notify list',
'notify_added_email_body' => 'Added to notification list
Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'notify_added_email_subject' => '[sitename]: [name] - Added to notification list',
'notify_deleted_email' => 'You\'ve been removed from notify list',
'notify_deleted_email_body' => 'Removed from notification list
Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'notify_deleted_email_subject' => '[sitename]: [name] - Removed from notification list',
'november' => 'November',
'now' => 'now',
'no_action' => 'No action required',
'no_approval_needed' => 'No approval pending.',
'no_attached_files' => 'No attached files',
'no_default_keywords' => 'No keywords available',
'no_docs_locked' => 'No documents locked.',
'no_docs_to_approve' => 'There are currently no documents that require approval.',
'no_docs_to_look_at' => 'No documents that need attention.',
'no_docs_to_review' => 'There are currently no documents that require review.',
'no_fulltextindex' => 'No fulltext index available',
'no_groups' => 'No groups',
'no_group_members' => 'This group has no members',
'no_linked_files' => 'No linked files',
'no_previous_versions' => 'No other versions found',
'no_review_needed' => 'No review pending.',
'no_update_cause_locked' => 'You can therefore not update this document. Please contact the locking user.',
'no_user_image' => 'No image found',
'objectcheck' => 'Folder/Document check',
'obsolete' => 'Obsolete',
'october' => 'October',
'old' => 'Old',
'only_jpg_user_images' => 'Only .jpg-images may be used as user-images',
'original_filename' => 'Original filename',
'owner' => 'Owner',
'ownership_changed_email' => 'Owner changed',
'ownership_changed_email_body' => 'Owner changed
Document: [name]
Parent folder: [folder_path]
Old owner: [old_owner]
New owner: [new_owner]
User: [username]
URL: [url]',
'ownership_changed_email_subject' => '[sitename]: [name] - Owner changed',
'password' => 'Password',
'password_already_used' => 'Password already used',
'password_expiration' => 'Password expiration',
'password_expiration_text' => 'Your password has expired. Please choose a new one before you can proceed using SeedDMS.',
'password_forgotten' => 'Password forgotten',
'password_forgotten_email_body' => 'Dear user of SeedDMS,

we have received a request to change your password.

This can be done by clicking on the following link:

###URL_PREFIX###out/out.ChangePassword.php?hash=###HASH###

If you have still problems to login, then please contact your administrator.',
'password_forgotten_email_subject' => 'Password forgotten',
'password_forgotten_send_hash' => 'Instructions on how to proceed has been send to the user\'s email address',
'password_forgotten_text' => 'Fill out the form below and follow the instructions in the email, which will be sent to you.',
'password_forgotten_title' => 'Password sent',
'password_repeat' => 'Repeat password',
'password_strength' => 'Password strength',
'password_strength_insuffient' => 'Insuffient password strength',
'password_wrong' => 'Wrong password',
'personal_default_keywords' => 'Personal keywordlists',
'pl_PL' => 'Polish',
'previous_state' => 'Previous state',
'previous_versions' => 'Previous versions',
'pt_BR' => 'Portugese (BR)',
'quota' => 'Quota',
'quota_exceeded' => 'Your disk quota is exceeded by [bytes].',
'quota_warning' => 'Your maximum disc usage is exceeded by [bytes]. Please remove documents or previous versions.',
'refresh' => 'Refresh',
'rejected' => 'Rejected',
'released' => 'Released',
'removed_approver' => 'has been removed from the list of approvers.',
'removed_file_email' => 'Removed attachment',
'removed_file_email_body' => 'Removed attachment
Document: [document]
User: [username]
URL: [url]',
'removed_file_email_subject' => '[sitename]: [document] - Removed attachment',
'removed_reviewer' => 'has been removed from the list of reviewers.',
'removed_workflow_email_body' => 'Removed workflow from document version
Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'removed_workflow_email_subject' => '[sitename]: [name] - Removed workflow from document version',
'remove_marked_files' => 'Remove marked files',
'repaired' => 'repaired',
'repairing_objects' => 'Repairing documents and folders.',
'results_page' => 'Results Page',
'return_from_subworkflow' => 'Return from sub workflow',
'return_from_subworkflow_email_body' => 'Return from subworkflow
Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'return_from_subworkflow_email_subject' => '[sitename]: [name] - Return from subworkflow',
'reviewers' => 'Reviewers',
'reviewer_already_assigned' => 'is already assigned as a reviewer',
'reviewer_already_removed' => 'has already been removed from review process or has already submitted a review',
'review_deletion_email' => 'Review request deleted',
'review_group' => 'Review group',
'review_request_email' => 'Review request',
'review_status' => 'Review status:',
'review_submit_email' => 'Submitted review',
'review_submit_email_body' => 'Submitted review
Document: [name]
Version: [version]
Status: [status]
Comment: [comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_submit_email_subject' => '[sitename]: [name] - Submitted review',
'review_summary' => 'Review Summary',
'review_update_failed' => 'Error updating review status. Update failed.',
'rewind_workflow' => 'Rewind workflow',
'rewind_workflow_email_body' => 'Workflow was rewinded
Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'rewind_workflow_email_subject' => '[sitename]: [name] - Workflow was rewinded',
'rewind_workflow_warning' => 'If you rewind a workflow to its initial state, then the whole workflow log for this document will be deleted and cannot be recovered.',
'rm_attrdef' => 'Remove attribute definition',
'rm_default_keyword_category' => 'Remove category',
'rm_document' => 'Remove document',
'rm_document_category' => 'Remove category',
'rm_file' => 'Remove file',
'rm_folder' => 'Remove folder',
'rm_from_clipboard' => 'Remove from clipboard',
'rm_group' => 'Remove this group',
'rm_user' => 'Remove this user',
'rm_version' => 'Remove version',
'rm_workflow' => 'Remove Workflow',
'rm_workflow_action' => 'Remove Workflow Action',
'rm_workflow_state' => 'Remove Workflow State',
'rm_workflow_warning' => 'You are about to remove the workflow from the document. This cannot be undone.',
'role' => 'Role',
'role_admin' => 'Administrator',
'role_guest' => 'Guest',
'role_user' => 'User',
'run_subworkflow' => 'Run sub workflow',
'run_subworkflow_email_body' => 'Subworkflow was started
Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'run_subworkflow_email_subject' => '[sitename]: [name] - Subworkflow was started',
'ru_RU' => 'Russian',
'saturday' => 'Saturday',
'saturday_abbr' => 'Sa',
'save' => 'Save',
'search' => 'Search',
'search_fulltext' => 'Search in fulltext',
'search_in' => 'Search in',
'search_mode_and' => 'all words',
'search_mode_or' => 'at least one word',
'search_no_results' => 'There are no documents that match your search',
'search_query' => 'Search for',
'search_report' => 'Found [doccount] documents and [foldercount] folders in [searchtime] sec.',
'search_report_fulltext' => 'Found [doccount] documents',
'search_results' => 'Search results',
'search_results_access_filtered' => 'Search results may contain content to which access has been denied.',
'search_time' => 'Elapsed time: [time] sec.',
'seconds' => 'seconds',
'selection' => 'Selection',
'select_category' => 'Click to select category',
'select_groups' => 'Click to select groups',
'select_grp_approvers' => 'Click to select group approver',
'select_grp_reviewers' => 'Click to select group reviewer',
'select_ind_approvers' => 'Click to select individual approver',
'select_ind_reviewers' => 'Click to select individual reviewer',
'select_one' => 'Select one',
'select_users' => 'Click to select users',
'select_workflow' => 'Select workflow',
'september' => 'September',
'sequence' => 'Sequence',
'seq_after' => 'After "[prevname]"',
'seq_end' => 'At the end',
'seq_keep' => 'Keep Position',
'seq_start' => 'First position',
'settings' => 'Settings',
'settings_activate_module' => 'Activate module',
'settings_activate_php_extension' => 'Activate PHP extension',
'settings_adminIP' => 'Admin IP',
'settings_adminIP_desc' => 'If set admin can login only by specified IP addres, leave empty to avoid the control. NOTE: works only with local autentication (no LDAP)',
'settings_Advanced' => 'Advanced',
'settings_apache_mod_rewrite' => 'Apache - Module Rewrite',
'settings_Authentication' => 'Authentication settings',
'settings_cacheDir' => 'Cache directory',
'settings_cacheDir_desc' => 'Where the preview images are stored (best to choose a directory that is not accessible through your web-server)',
'settings_Calendar' => 'Calendar settings',
'settings_calendarDefaultView' => 'Calendar Default View',
'settings_calendarDefaultView_desc' => 'Calendar default view',
'settings_cannot_disable' => 'File ENABLE_INSTALL_TOOL could not deleted',
'settings_contentDir' => 'Content directory',
'settings_contentDir_desc' => 'Where the uploaded files are stored (best to choose a directory that is not accessible through your web-server)',
'settings_contentOffsetDir' => 'Content Offset Directory',
'settings_contentOffsetDir_desc' => 'To work around limitations in the underlying file system, a new directory structure has been devised that exists within the content directory (Content Directory). This requires a base directory from which to begin. Usually leave this to the default setting, 1048576, but can  be any number or string that does not already exist within (Content Directory)',
'settings_cookieLifetime' => 'Cookie Life time',
'settings_cookieLifetime_desc' => 'The life time of a cookie in seconds. If set to 0 the cookie will be removed when the browser is closed.',
'settings_coreDir' => 'Core SeedDMS directory',
'settings_coreDir_desc' => 'Path to SeedDMS_Core (optional). Leave this empty if you have installed SeedDMS_Core at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_createdatabase' => 'Create database tables',
'settings_createdirectory' => 'Create directory',
'settings_currentvalue' => 'Current value',
'settings_Database' => 'Database settings',
'settings_dbDatabase' => 'Database',
'settings_dbDatabase_desc' => 'The name for your database entered during the installation process. Do not edit this field unless necessary, if for example the database has been moved.',
'settings_dbDriver' => 'Database Type',
'settings_dbDriver_desc' => 'The type of database in use entered during the installation process. Do not edit this field unless you are having to migrate to a different type of database perhaps due to changing hosts. Type of DB-Driver used by adodb (see adodb-readme)',
'settings_dbHostname' => 'Server name',
'settings_dbHostname_desc' => 'The hostname for your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbPass' => 'Password',
'settings_dbPass_desc' => 'The password for access to your database entered during the installation process.',
'settings_dbUser' => 'Username',
'settings_dbUser_desc' => 'The username for access to your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbVersion' => 'Database schema too old',
'settings_delete_install_folder' => 'In order to use SeedDMS, you must delete the file ENABLE_INSTALL_TOOL in the configuration directory',
'settings_disableSelfEdit' => 'Disable Self Edit',
'settings_disableSelfEdit_desc' => 'If checked user cannot edit his own profile',
'settings_disable_install' => 'Delete file ENABLE_INSTALL_TOOL if possible',
'settings_Display' => 'Display settings',
'settings_dropFolderDir' => 'Directory for drop folder',
'settings_dropFolderDir_desc' => 'This directory can be used for dropping files on the server\'s file system and importing them from there instead of uploading via the browser. The directory must contain a sub directory for each user who is allowed to import files this way.',
'settings_Edition' => 'Edition settings',
'settings_enableAdminRevApp' => 'Allow review/approval for admins',
'settings_enableAdminRevApp_desc' => 'Enable this if you want administrators to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableCalendar' => 'Enable Calendar',
'settings_enableCalendar_desc' => 'Enable/disable calendar',
'settings_enableClipboard' => 'Enable Clipboard',
'settings_enableClipboard_desc' => 'Enable/disable the clipboard',
'settings_enableConverting' => 'Enable Converting',
'settings_enableConverting_desc' => 'Enable/disable converting of files',
'settings_enableDuplicateDocNames' => 'Allow duplicate document names',
'settings_enableDuplicateDocNames_desc' => 'Allows to have duplicate document names in a folder.',
'settings_enableEmail' => 'Enable E-mail',
'settings_enableEmail_desc' => 'Enable/disable automatic email notification',
'settings_enableFolderTree' => 'Enable Folder Tree',
'settings_enableFolderTree_desc' => 'False to don\'t show the folder tree',
'settings_enableFullSearch' => 'Enable Full text search',
'settings_enableFullSearch_desc' => 'Enable Full text search',
'settings_enableGuestLogin' => 'Enable Guest Login',
'settings_enableGuestLogin_desc' => 'If you want anybody to login as guest, check this option. Note: guest login should be used only in a trusted environment',
'settings_enableLanguageSelector' => 'Enable Language Selector',
'settings_enableLanguageSelector_desc' => 'Show selector for user interface language after being logged in.',
'settings_enableLargeFileUpload' => 'Enable large file upload',
'settings_enableLargeFileUpload_desc' => 'If set, file upload is also available through a java applet called jumploader without a file size limit set by the browser. It also allows to upload several files in one step.',
'settings_enableNotificationAppRev' => 'Enable reviewer/approver notification',
'settings_enableNotificationAppRev_desc' => 'Check to send a notification to the reviewer/approver when a new document version is added',
'settings_enableOwnerNotification' => 'Enable owner notification by default',
'settings_enableOwnerNotification_desc' => 'Check for adding a notification for the owner if a document when it is added.',
'settings_enableOwnerRevApp' => 'Allow review/approval for owner',
'settings_enableOwnerRevApp_desc' => 'Enable this if you want the owner of a document to be listed as reviewers/approvers and for workflow transitions.',
'settings_enablePasswordForgotten' => 'Enable Password forgotten',
'settings_enablePasswordForgotten_desc' => 'If you want to allow user to set a new password and send it by mail, check this option.',
'settings_enableRecursiveCount' => 'Enable recursive document/folder count',
'settings_enableRecursiveCount_desc' => 'If turned on, the number of documents and folders in the folder view will be determined by counting all objects by recursively processing the folders and counting those documents and folders the user is allowed to access.',
'settings_enableSelfRevApp' => 'Allow review/approval for logged in user',
'settings_enableSelfRevApp_desc' => 'Enable this if you want the currently logged in user to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableThemeSelector' => 'Theme selection',
'settings_enableThemeSelector_desc' => 'Turns on/off the theme selector on the login page.',
'settings_enableUserImage' => 'Enable User Image',
'settings_enableUserImage_desc' => 'Enable users images',
'settings_enableUsersView' => 'Enable Users View',
'settings_enableUsersView_desc' => 'Enable/disable group and user view for all users',
'settings_enableVersionDeletion' => 'Enable deletion of previous versions',
'settings_enableVersionDeletion_desc' => 'Enable/disable deletion of previous document versions by regular users. Admin may always delete old versions.',
'settings_enableVersionModification' => 'Enable modification of versions',
'settings_enableVersionModification_desc' => 'Enable/disable modification of a document versions by regular users after a version was uploaded. Admin may always modify the version after upload.',
'settings_encryptionKey' => 'Encryption key',
'settings_encryptionKey_desc' => 'This string is used for creating a unique identifier being added as a hidden field to a formular in order to prevent CSRF attacks.',
'settings_error' => 'Error',
'settings_expandFolderTree' => 'Expand Folder Tree',
'settings_expandFolderTree_desc' => 'Expand Folder Tree',
'settings_expandFolderTree_val0' => 'start with tree hidden',
'settings_expandFolderTree_val1' => 'start with tree shown and first level expanded',
'settings_expandFolderTree_val2' => 'start with tree shown fully expanded',
'settings_Extensions' => 'Extensions',
'settings_extraPath' => 'Extra PHP include Path',
'settings_extraPath_desc' => 'Path to additional software. This is the directory containing e.g. the adodb directory or additional pear packages',
'settings_firstDayOfWeek' => 'First day of the week',
'settings_firstDayOfWeek_desc' => 'First day of the week',
'settings_footNote' => 'Foot Note',
'settings_footNote_desc' => 'Message to display at the bottom of every page',
'settings_guestID' => 'Guest ID',
'settings_guestID_desc' => 'ID of guest-user used when logged in as guest (mostly no need to change)',
'settings_httpRoot' => 'Http Root',
'settings_httpRoot_desc' => 'The relative path in the URL, after the domain part. Do not include the http:// prefix or the web host name. e.g. If the full URL is http://www.example.com/seeddms/, set \'/seeddms/\'. If the URL is http://www.example.com/, set \'/\'',
'settings_installADOdb' => 'Install ADOdb',
'settings_install_disabled' => 'File ENABLE_INSTALL_TOOL was deleted. You can now log into SeedDMS and do further configuration.',
'settings_install_pear_package_log' => 'Install Pear package \'Log\'',
'settings_install_pear_package_webdav' => 'Install Pear package \'HTTP_WebDAV_Server\', if you intend to use the webdav interface',
'settings_install_success' => 'The installation has been successfully completed.',
'settings_install_welcome_text' => '<p>Before you start to install SeedDMS make sure you have created a file \'ENABLE_INSTALL_TOOL\' in your configuration directory, otherwise the installation will not work. On Unix-System this can easily be done with \'touch conf/ENABLE_INSTALL_TOOL\'. After you have finished the installation delete the file.</p><p>SeedDMS has very minimal requirements. You will need a mysql database or sqlite support and a php enabled web server. The pear package Log has to be installed too. For the lucene full text search, you will also need the Zend framework installed on disk where it can be found by php. For the WebDAV server you will also need the HTTP_WebDAV_Server. The path to it can later be set during installation.</p><p>If you like to create the database before you start installation, then just create it manually with your favorite tool, optionally create a database user with access on the database and import one of the database dumps in the configuration directory. The installation script can do that for you as well, but it will need database access with sufficient rights to create databases.</p>',
'settings_install_welcome_title' => 'Welcome to the installation of SeedDMS',
'settings_install_zendframework' => 'Install Zend Framework, if you intend to use the full text search engine',
'settings_language' => 'Default language',
'settings_language_desc' => 'Default language (name of a subfolder in folder "languages")',
'settings_logFileEnable' => 'Log File Enable',
'settings_logFileEnable_desc' => 'Enable/disable log file',
'settings_logFileRotation' => 'Log File Rotation',
'settings_logFileRotation_desc' => 'The log file rotation',
'settings_loginFailure' => 'Login failure',
'settings_loginFailure_desc' => 'Disable account after n login failures.',
'settings_luceneClassDir' => 'Lucene SeedDMS directory',
'settings_luceneClassDir_desc' => 'Path to SeedDMS_Lucene (optional). Leave this empty if you have installed SeedDMS_Lucene at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_luceneDir' => 'Directory for full text index',
'settings_luceneDir_desc' => 'Path to Lucene index',
'settings_maxDirID' => 'Max Directory ID',
'settings_maxDirID_desc' => 'Maximum number of sub-directories per parent directory. Default: 32700.',
'settings_maxExecutionTime' => 'Max Execution Time (s)',
'settings_maxExecutionTime_desc' => 'This sets the maximum time in seconds a script is allowed to run before it is terminated by the parse',
'settings_maxRecursiveCount' => 'Max. number of recursive document/folder count',
'settings_maxRecursiveCount_desc' => 'This is the maximum number of documents or folders that will be checked for access rights, when recursively counting objects. If this number is exceeded, the number of documents and folders in the folder view will be estimated.',
'settings_more_settings' => 'Configure more settings. Default login: admin/admin',
'settings_notfound' => 'Not found',
'settings_Notification' => 'Notification settings',
'settings_notwritable' => 'The configuration cannot be saved because the configuration file is not writable.',
'settings_no_content_dir' => 'Content directory',
'settings_partitionSize' => 'Partial filesize',
'settings_partitionSize_desc' => 'Size of partial files in bytes, uploaded by jumploader. Do not set a value larger than the maximum upload size set by the server.',
'settings_passwordExpiration' => 'Password expiration',
'settings_passwordExpiration_desc' => 'The number of days after which a password expireѕ and must be reset. 0 turns password expiration off.',
'settings_passwordHistory' => 'Password history',
'settings_passwordHistory_desc' => 'The number of passwords a user must have been used before a password can be reused. 0 turns the password history off.',
'settings_passwordStrength' => 'Min. password strength',
'settings_passwordStrengthAlgorithm' => 'Algorithm for password strength',
'settings_passwordStrengthAlgorithm_desc' => 'The algorithm used for calculating the password strength. The \'simple\' algorithm just checks for at least eight chars total, a lower case letter, an upper case letter, a number and a special char. If those conditions are met the returned score is 100 otherwise 0.',
'settings_passwordStrengthAlgorithm_valadvanced' => 'advanced',
'settings_passwordStrengthAlgorithm_valsimple' => 'simple',
'settings_passwordЅtrength_desc' => 'The minimum password strength is an integer value from 0 to 100. Setting it to 0 will turn off checking for the minimum password strength.',
'settings_pear_log' => 'Pear package : Log',
'settings_pear_webdav' => 'Pear package : HTTP_WebDAV_Server',
'settings_perms' => 'Permissions',
'settings_php_dbDriver' => 'PHP extension : php_\'see current value\'',
'settings_php_gd2' => 'PHP extension : php_gd2',
'settings_php_mbstring' => 'PHP extension : php_mbstring',
'settings_php_version' => 'PHP version',
'settings_printDisclaimer' => 'Print Disclaimer',
'settings_printDisclaimer_desc' => 'If true the disclaimer message the lang.inc files will be print on the bottom of the page',
'settings_quota' => 'User\'s quota',
'settings_quota_desc' => 'The maximum number of bytes a user may use on disk. Set this to 0 for unlimited disk space. This value can be overridden for each uses in his profile.',
'settings_restricted' => 'Restricted access',
'settings_restricted_desc' => 'Only allow users to log in if they have an entry in the local database (irrespective of successful authentication with LDAP)',
'settings_rootDir' => 'Root directory',
'settings_rootDir_desc' => 'Path to where SeedDMS is located',
'settings_rootFolderID' => 'Root Folder ID',
'settings_rootFolderID_desc' => 'ID of root-folder (mostly no need to change)',
'settings_SaveError' => 'Configuration file save error',
'settings_Server' => 'Server settings',
'settings_Site' => 'Site',
'settings_siteDefaultPage' => 'Site Default Page',
'settings_siteDefaultPage_desc' => 'Default page on login. If empty defaults to out/out.ViewFolder.php',
'settings_siteName' => 'Site Name',
'settings_siteName_desc' => 'Name of site used in the page titles. Default: SeedDMS',
'settings_SMTP' => 'SMTP Server settings',
'settings_smtpPassword' => 'SMTP Server password',
'settings_smtpPassword_desc' => 'SMTP Server password',
'settings_smtpPort' => 'SMTP Server port',
'settings_smtpPort_desc' => 'SMTP Server port, default 25',
'settings_smtpSendFrom' => 'Send from',
'settings_smtpSendFrom_desc' => 'Send from',
'settings_smtpServer' => 'SMTP Server hostname',
'settings_smtpServer_desc' => 'SMTP Server hostname',
'settings_smtpUser' => 'SMTP Server user',
'settings_smtpUser_desc' => 'SMTP Server user',
'settings_sortFoldersDefault' => 'Default sort method',
'settings_sortFoldersDefault_desc' => 'This sets the sort methods for folders and documents in the folder view.',
'settings_sortFoldersDefault_val_name' => 'by name',
'settings_sortFoldersDefault_val_sequence' => 'by sequence',
'settings_sortFoldersDefault_val_unsorted' => 'unsorted',
'settings_sortUsersInList' => 'Sort users in list',
'settings_sortUsersInList_desc' => 'Sets if users in selection menus are ordered by login or by its full name',
'settings_sortUsersInList_val_fullname' => 'Sort by full name',
'settings_sortUsersInList_val_login' => 'Sort by login',
'settings_stagingDir' => 'Directory for partial uploads',
'settings_stagingDir_desc' => 'The directory where jumploader places the parts of a file upload before it is put back together.',
'settings_start_install' => 'Start installation',
'settings_stopWordsFile' => 'Path to stop words file',
'settings_stopWordsFile_desc' => 'If fulltext search is enabled, this file will contain stop words not being indexed',
'settings_strictFormCheck' => 'Strict Form Check',
'settings_strictFormCheck_desc' => 'Strict form checking. If set to true, then all fields in the form will be checked for a value. If set to false, then (most) comments and keyword fields become optional. Comments are always required when submitting a review or overriding document status',
'settings_suggestionvalue' => 'Suggestion value',
'settings_System' => 'System',
'settings_theme' => 'Default theme',
'settings_theme_desc' => 'Default style (name of a subfolder in folder "styles")',
'settings_titleDisplayHack' => 'Title Display Hack',
'settings_titleDisplayHack_desc' => 'Workaround for page titles that go over more than 2 lines.',
'settings_undelUserIds' => 'Undeletable User IDs',
'settings_undelUserIds_desc' => 'Comma separated list of user ids, that cannot be deleted.',
'settings_updateDatabase' => 'Run schema update scripts on database',
'settings_updateNotifyTime' => 'Update Notify Time',
'settings_updateNotifyTime_desc' => 'Users are notified about document-changes that took place within the last \'Update Notify Time\' seconds',
'settings_upgrade_php' => 'Upgrade PHP to at least version 5.2.0',
'settings_versioningFileName' => 'Versioning FileName',
'settings_versioningFileName_desc' => 'The name of the versioning info file created by the backup tool',
'settings_versiontolow' => 'Version to low',
'settings_viewOnlineFileTypes' => 'View Online File Types',
'settings_viewOnlineFileTypes_desc' => 'Files with one of the following endings can be viewed online (USE ONLY LOWER CASE CHARACTERS)',
'settings_workflowMode' => 'Workflow mode',
'settings_workflowMode_desc' => 'The advanced workflow allows to specify your own release workflow for document versions.',
'settings_workflowMode_valadvanced' => 'advanced',
'settings_workflowMode_valtraditional' => 'traditional',
'settings_zendframework' => 'Zend Framework',
'set_expiry' => 'Set Expiration',
'set_owner' => 'Set Owner',
'set_owner_error' => 'Error setting owner',
'set_password' => 'Set Password',
'set_workflow' => 'Set Workflow',
'signed_in_as' => 'Signed in as',
'sign_in' => 'Sign in',
'sign_out' => 'Sign out',
'sign_out_user' => 'Sign out user',
'sk_SK' => 'Slovak',
'space_used_on_data_folder' => 'Space used on data folder',
'splash_added_to_clipboard' => 'Added to clipboard',
'splash_add_attribute' => 'New attribute added',
'splash_add_group' => 'New group added',
'splash_add_group_member' => 'New group member added',
'splash_add_user' => 'New user added',
'splash_cleared_clipboard' => 'Clipboard cleared',
'splash_document_edited' => 'Document saved',
'splash_document_locked' => 'Document locked',
'splash_document_unlocked' => 'Document unlocked',
'splash_edit_attribute' => 'Attribute saved',
'splash_edit_group' => 'Group saved',
'splash_edit_user' => 'User saved',
'splash_folder_edited' => 'Save folder changes',
'splash_invalid_folder_id' => 'Invalid folder ID',
'splash_invalid_searchterm' => 'Invalid search term',
'splash_moved_clipboard' => 'Clipboard moved into current folder',
'splash_removed_from_clipboard' => 'Removed from clipboard',
'splash_rm_attribute' => 'Attribute removed',
'splash_rm_group' => 'Group removed',
'splash_rm_group_member' => 'Member of group removed',
'splash_rm_user' => 'User removed',
'splash_settings_saved' => 'Settings saved',
'splash_substituted_user' => 'Substituted user',
'splash_switched_back_user' => 'Switched back to original user',
'splash_toogle_group_manager' => 'Group manager toogled',
'state_and_next_state' => 'State/Next state',
'statistic' => 'Statistic',
'status' => 'Status',
'status_approval_rejected' => 'Draft rejected',
'status_approved' => 'Approved',
'status_approver_removed' => 'Approver removed from process',
'status_not_approved' => 'Not approved',
'status_not_reviewed' => 'Not reviewed',
'status_reviewed' => 'Reviewed',
'status_reviewer_rejected' => 'Draft rejected',
'status_reviewer_removed' => 'Reviewer removed from process',
'status_unknown' => 'Unknown',
'storage_size' => 'Storage size',
'submit_approval' => 'Submit approval',
'submit_login' => 'Sign in',
'submit_password' => 'Set new password',
'submit_password_forgotten' => 'Start process',
'submit_review' => 'Submit review',
'submit_userinfo' => 'Submit info',
'substitute_user' => 'Substitute User',
'sunday' => 'Sunday',
'sunday_abbr' => 'Su',
'sv_SE' => 'Swedish',
'switched_to' => 'Switched to',
'testmail_body' => 'This mail is just for testing the mail configuration of SeedDMS',
'testmail_subject' => 'Test mail',
'theme' => 'Theme',
'thursday' => 'Thursday',
'thursday_abbr' => 'Th',
'to' => 'To',
'toggle_manager' => 'Toggle manager',
'transition_triggered_email' => 'Workflow transition triggered',
'transition_triggered_email_body' => 'Workflow transition triggered
Document: [name]
Version: [version]
Comment: [comment]
Workflow: [workflow]
Previous state: [previous_state]
Current state: [current_state]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'transition_triggered_email_subject' => '[sitename]: [name] - Workflow transition triggered',
'trigger_workflow' => 'Workflow',
'tuesday' => 'Tuesday',
'tuesday_abbr' => 'Tu',
'type_to_search' => 'Type to search',
'under_folder' => 'In Folder',
'unknown_command' => 'Command not recognized.',
'unknown_document_category' => 'Unknown category',
'unknown_group' => 'Unknown group id',
'unknown_id' => 'unknown id',
'unknown_keyword_category' => 'Unknown category',
'unknown_owner' => 'Unknown owner id',
'unknown_user' => 'Unknown user id',
'unlinked_content' => 'Unlinked content',
'unlinked_documents' => 'Unlinked documents',
'unlinked_folders' => 'Unlinked folders',
'unlinking_objects' => 'Unlinking content',
'unlock_cause_access_mode_all' => 'You can still update it because you have access-mode "all". Locking will automatically be removed.',
'unlock_cause_locking_user' => 'You can still update it because you are also the one that locked it. Locking will automatically be removed.',
'unlock_document' => 'Unlock',
'update' => 'Update',
'update_approvers' => 'Update List of Approvers',
'update_document' => 'Update document',
'update_fulltext_index' => 'Update fulltext index',
'update_info' => 'Update Information',
'update_locked_msg' => 'This document is locked.',
'update_reviewers' => 'Update List of Reviewers',
'uploaded_by' => 'Uploaded by',
'uploading_failed' => 'Uploading one of your files failed. Please check your maximum upload file size.',
'uploading_zerosize' => 'Uploading an empty file. Upload is canceled.',
'used_discspace' => 'Used disk space',
'user' => 'User',
'users' => 'Users',
'users_and_groups' => 'Users/Groups',
'users_done_work' => 'Users done work',
'user_exists' => 'User already exists.',
'user_group_management' => 'Users/Groups management',
'user_image' => 'Image',
'user_info' => 'User Information',
'user_list' => 'List of Users',
'user_login' => 'User ID',
'user_management' => 'Users management',
'user_name' => 'Full name',
'use_comment_of_document' => 'Use comment of document',
'use_default_categories' => 'Use predefined categories',
'use_default_keywords' => 'Use predefined keywords',
'version' => 'Version',
'versioning_file_creation' => 'Versioning file creation',
'versioning_file_creation_warning' => 'With this operation you can create a file containing the versioning information of an entire DMS folder. After the creation every file will be saved inside the document folder.',
'versioning_info' => 'Versioning info',
'versiontolow' => 'Version to low',
'version_deleted_email' => 'Version deleted',
'version_deleted_email_body' => 'Version deleted
Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'version_deleted_email_subject' => '[sitename]: [name] - Version deleted',
'version_info' => 'Version Information',
'view' => 'View',
'view_online' => 'View online',
'warning' => 'Warning',
'wednesday' => 'Wednesday',
'wednesday_abbr' => 'We',
'weeks' => 'weeks',
'week_view' => 'Week view',
'workflow' => 'Workflow',
'workflow_actions_management' => 'Workflow actions management',
'workflow_action_in_use' => 'This action is currently used by workflows.',
'workflow_action_name' => 'Name',
'workflow_editor' => 'Workflow Editor',
'workflow_group_summary' => 'Group summary',
'workflow_initstate' => 'Initial state',
'workflow_in_use' => 'This workflow is currently used by documents.',
'workflow_management' => 'Workflow management',
'workflow_name' => 'Name',
'workflow_no_states' => 'You must first define workflow states, before adding a workflow.',
'workflow_states_management' => 'Workflow states management',
'workflow_state_docstatus' => 'Document status',
'workflow_state_in_use' => 'This state is currently used by workflows.',
'workflow_state_name' => 'Name',
'workflow_summary' => 'Workflow summary',
'workflow_user_summary' => 'User summary',
'year_view' => 'Year View',
'yes' => 'Yes',
'zh_CN' => 'Chinese (CN)',
'zh_TW' => 'Chinese (TW)',
);
?>
