/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.lang;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringHelper {
    static final String C = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final SimpleDateFormat B = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss Z");
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String EOL = "\r\n";
    public static final String DEFAULT_DELIM = ",";
    protected static StringHelper A = null;

    protected StringHelper() {
    }

    public static synchronized StringHelper getInstance() {
        if (A == null) {
            A = new StringHelper();
        }
        return A;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n) + string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n, char c2) {
        int n2;
        if (string == null) {
            string = "";
        }
        if ((n2 = string.length()) >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, c2);
        }
        return stringBuffer.toString();
    }

    public static String encode(String string, String string2, String string3) throws UnsupportedEncodingException {
        return string == null ? null : new String(string2 == null ? string.getBytes() : string.getBytes(string2), string3);
    }

    public static String toXmlAttr(String string) {
        String string2 = null;
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            block6: for (int k = 0; k < n; ++k) {
                char c2 = string.charAt(k);
                switch (c2) {
                    case '\"': {
                        stringBuffer.append("&#34;");
                        continue block6;
                    }
                    case '<': {
                        stringBuffer.append("&#60;");
                        continue block6;
                    }
                    case '>': {
                        stringBuffer.append("&#62;");
                        continue block6;
                    }
                    case '&': {
                        stringBuffer.append("&#38;");
                        continue block6;
                    }
                    default: {
                        stringBuffer.append(c2);
                    }
                }
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static final String base64Encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 2) / 3 * 4);
        int n = 0;
        while (n + 2 < byArray.length) {
            stringBuffer.append(C.charAt((byArray[n] & 0xFC) >> 2));
            stringBuffer.append(C.charAt((byArray[n] & 3) << 4 | (byArray[n + 1] & 0xF0) >> 4));
            stringBuffer.append(C.charAt((byArray[n + 1] & 0xF) << 2 | (byArray[n + 2] & 0xC0) >> 6));
            stringBuffer.append(C.charAt(byArray[n + 2] & 0x3F));
            n += 3;
        }
        switch (byArray.length - n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append(C.charAt((byArray[n] & 0xFC) >> 2));
                stringBuffer.append(C.charAt((byArray[n] & 3) << 4));
                stringBuffer.append("==");
                break;
            }
            case 2: {
                stringBuffer.append(C.charAt((byArray[n] & 0xFC) >> 2));
                stringBuffer.append(C.charAt((byArray[n] & 3) << 4 | (byArray[n + 1] & 0xF0) >> 4));
                stringBuffer.append(C.charAt((byArray[n + 1] & 0xF) << 2));
                stringBuffer.append("=");
                break;
            }
            default: {
                throw new RuntimeException("Can't have other than 0, 1, or 2");
            }
        }
        return stringBuffer.toString();
    }

    public static final byte[] base64Decode(String string) throws NumberFormatException {
        string = string.replace('=', ' ').trim();
        byte[] byArray = new byte[string.length() * 3 / 4];
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        do {
            int n3;
            if ((n3 = C.indexOf(cArray[n2])) < 0) {
                throw new NumberFormatException("Invalid character " + cArray[n2] + " in base 64 string");
            }
            if (++n2 == cArray.length) break;
            int n4 = C.indexOf(cArray[n2]);
            if (n4 < 0) {
                throw new NumberFormatException("Invalid character " + cArray[n2] + " in base 64 string");
            }
            byArray[n++] = (byte)((n3 << 2) + (n4 >> 4));
            if (++n2 == cArray.length) break;
            int n5 = C.indexOf(cArray[n2]);
            if (n5 < 0) {
                throw new NumberFormatException("Invalid character " + cArray[n2] + " in base 64 string");
            }
            byArray[n++] = (byte)((n4 << 4 & 0xF0) + (n5 >> 2));
            if (++n2 == cArray.length) break;
            int n6 = C.indexOf(cArray[n2]);
            if (n6 < 0) {
                throw new NumberFormatException("Invalid character " + cArray[n2] + " in base 64 string ");
            }
            byArray[n++] = (byte)((n5 << 6 & 0xC0) + n6);
        } while (++n2 != cArray.length);
        return byArray;
    }

    public static String convert(String string, String string2, String string3) throws UnsupportedEncodingException {
        byte[] byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
        String string4 = string3 == null ? new String(byArray) : new String(byArray, string3);
        return string4;
    }

    public static String toString(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            if (string == null) {
                string = "";
            }
            for (int k = 0; k < objectArray.length; ++k) {
                stringBuffer.append((k > 0 ? string : "") + objectArray[k]);
            }
        }
        return stringBuffer.toString();
    }

    public static String toHtmlAttribute(Long l) {
        return l == null ? "" : "" + l;
    }

    public static String toHtmlAttribute(String string) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            int n = string.length();
            stringBuffer = new StringBuffer(n + 10);
            for (int k = 0; k < n; ++k) {
                char c2 = string.charAt(k);
                if (Character.isDefined(c2)) {
                    if (c2 == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    if (c2 == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c2 == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c2 == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        return string == null ? "" : stringBuffer.toString();
    }

    public static String toHtmlText(String string) {
        StringBuffer stringBuffer = null;
        if (string != null) {
            int n = string.length();
            stringBuffer = new StringBuffer(n + 10);
            for (int k = 0; k < n; ++k) {
                char c2 = string.charAt(k);
                if (Character.isDefined(c2)) {
                    if (c2 == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c2 == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    if (c2 == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c2 == '\n') {
                        stringBuffer.append("<br>");
                        continue;
                    }
                    if (c2 == ' ') {
                        stringBuffer.append("&nbsp;");
                        continue;
                    }
                    stringBuffer.append(c2);
                    continue;
                }
                stringBuffer.append("?");
            }
        }
        return string == null ? "" : stringBuffer.toString();
    }

    public static int compare(String string, String string2) {
        int n = 0;
        n = string == null && string2 == null ? 0 : (string == null ? Integer.MIN_VALUE : (string2 == null ? Integer.MAX_VALUE : string.compareTo(string2)));
        return n;
    }

    public static int compareIgnoreCase(String string, String string2) {
        int n = 0;
        n = string == null && string2 == null ? 0 : (string == null ? Integer.MIN_VALUE : (string2 == null ? Integer.MAX_VALUE : string.compareToIgnoreCase(string2)));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = B;
        synchronized (simpleDateFormat) {
            return B.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = B;
        synchronized (simpleDateFormat) {
            return B.parse(string);
        }
    }

    public static String getStackTrace(Throwable throwable) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        stringWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public static Dimension parseDimension(String string) {
        Dimension dimension = new Dimension();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
        dimension.width = Integer.parseInt(stringTokenizer.nextToken());
        dimension.height = Integer.parseInt(stringTokenizer.nextToken());
        return dimension;
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int k = 0; k < byArray.length; ++k) {
                String string = Integer.toHexString(byArray[k] & 0xFF);
                if (string.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String nvl(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String getMultilineString(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.replace('|', '\r');
        }
        return string2;
    }

    public static Properties getProperties(String string) {
        Properties properties = new Properties();
        String string2 = StringHelper.getMultilineString(string);
        if (string2 != null) {
            try {
                properties.load(new ByteArrayInputStream(string2.getBytes(ISO_8859_1)));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to load properties, value='" + string + "'", iOException);
            }
        }
        return properties;
    }

    public static String notNull(String string) {
        return string == null ? "" : string;
    }

    public static String notNull(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String format(String string, Object ... objectArray) {
        return new MessageFormat(string).format(objectArray);
    }

    public static boolean parseBoolean(String string) {
        return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
    }

    public static boolean parseBoolean(String string, boolean bl) {
        return StringHelper.isEmpty(string) ? bl : StringHelper.parseBoolean(string);
    }

    public static String[] parseStringArray(String string) {
        return StringHelper.parseStringArray(string, DEFAULT_DELIM);
    }

    public static String[] parseStringArray(String string, String string2) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            for (int k = 0; k < n; ++k) {
                stringArray[k] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public static String[] toStringArray(String string, String string2) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            stringArray = new String[stringTokenizer.countTokens()];
            for (int k = 0; k < stringArray.length; ++k) {
                stringArray[k] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public static byte parseByte(String string) {
        return (byte)StringHelper.parseLong(string);
    }

    public static long parseLong(String string) {
        long l = 0L;
        string = string.trim();
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : (string.startsWith("#") ? Long.parseLong(string.substring(1), 16) : Long.parseLong(string, 16));
        }
        return l;
    }

    public static int parseInt(String string) {
        return (int)StringHelper.parseLong(string);
    }

    public static Integer parseIntObject(String string) {
        Integer n = null;
        if (string != null) {
            n = new Integer(StringHelper.parseInt(string));
        }
        return n;
    }

    public static short parseShort(String string) {
        return (short)StringHelper.parseLong(string);
    }

    public static double parseDouble(String string) {
        return Double.parseDouble(string.trim());
    }

    public static Double parseDoubleObject(String string) {
        Double d2 = null;
        if (string != null) {
            d2 = new Double(StringHelper.parseDouble(string));
        }
        return d2;
    }
}

